#ifndef _ASM_ARM_MODULE_H
#define _ASM_ARM_MODULE_H

#ifndef __ASSEMBLY__
#define Elf_Shdr	Elf32_Shdr
#define Elf_Sym		Elf32_Sym
#define Elf_Ehdr	Elf32_Ehdr

struct unwind_table;

struct mod_arch_specific
{
#ifdef CONFIG_ARM_UNWIND
	Elf_Shdr *unw_sec_init;
	Elf_Shdr *unw_sec_devinit;
	Elf_Shdr *unw_sec_core;
	Elf_Shdr *sec_init_text;
	Elf_Shdr *sec_devinit_text;
	Elf_Shdr *sec_core_text;
	struct unwind_table *unwind_init;
	struct unwind_table *unwind_devinit;
	struct unwind_table *unwind_core;
#endif
};

/*
 * Include the ARM architecture version.
 */
#define MODULE_ARCH_VERMAGIC	"ARMv" __stringify(__LINUX_ARM_ARCH__) " "

#if defined(CONFIG_FUNCTION_TRACER)
#if defined(CONFIG_MODULES_HIGH_VADDR) && defined(MODULE)
extern void __gnu_mcount_nc_internal(void);
static void __gnu_mcount_nc(void) __attribute__((weakref ("__gnu_mcount_nc_module")));
asm("\n"
"__gnu_mcount_nc_module:\n"
"	push	{r0, lr}\n"
"	ldr	r0, 1f\n"
"	blx	r0\n"
"1:	.word	__gnu_mcount_nc_internal\n"
);
#endif /* CONFIG_MODULES_HIGH_VADDR && defined(MODULE) */
#endif /* CONFIG_FUNCTION_TRACER */

#endif /* !__ASSEMBLY__ */

#endif /* _ASM_ARM_MODULE_H */
